/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Device;
import com.ftdi.j2xx.interfaces.I2cSlave;

public class FT_4222_I2c_Slave
implements I2cSlave {
    FT_4222_Device mFt4222Dev;
    FT_Device mFtDev;

    public FT_4222_I2c_Slave(FT_4222_Device ft4222Device) {
        this.mFt4222Dev = ft4222Device;
        this.mFtDev = this.mFt4222Dev.mFtDev;
    }

    int cmdSet(int wValue1, int wValue2) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8);
    }

    int cmdSet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8, buf, datalen);
    }

    int cmdGet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdGet(32, wValue1 | wValue2 << 8, buf, datalen);
    }

    @Override
    public int init() {
        int ftStatus = this.mFt4222Dev.init();
        if (0 != ftStatus) {
            return ftStatus;
        }
        if (!this.I2C_ModeCheck()) {
            return 1012;
        }
        ftStatus = this.cmdSet(5, 2);
        if (ftStatus < 0) {
            return ftStatus;
        }
        this.mFt4222Dev.mChipStatus.function = (byte)2;
        return 0;
    }

    @Override
    public int reset() {
        int reset = 1;
        int ftStatus = this.I2C_Check(false);
        if (0 != ftStatus) {
            return ftStatus;
        }
        return this.cmdSet(91, reset);
    }

    @Override
    public int getAddress(int[] addr) {
        byte[] bAddr = new byte[1];
        int ftStatus = this.I2C_Check(false);
        if (0 != ftStatus) {
            return ftStatus;
        }
        ftStatus = this.mFtDev.VendorCmdGet(33, 92, bAddr, 1);
        if (ftStatus < 0) {
            return 18;
        }
        addr[0] = bAddr[0];
        return 0;
    }

    @Override
    public int setAddress(int addr) {
        byte[] bAddr = new byte[]{(byte)(addr & 0xFF)};
        int ftStatus = this.I2C_Check(false);
        if (0 != ftStatus) {
            return ftStatus;
        }
        ftStatus = this.cmdSet(92, bAddr[0]);
        if (ftStatus < 0) {
            return 18;
        }
        return 0;
    }

    @Override
    public int read(byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        long startTime = System.currentTimeMillis();
        int iTimeout = this.mFtDev.getReadTimeout();
        int notReadBytes = sizeToTransfer;
        int readBytes = 0;
        if (buffer.length < sizeToTransfer) {
            return 1023;
        }
        if (sizeToTransfer < 1) {
            return 6;
        }
        int ftStatus = this.I2C_Check(false);
        if (0 != ftStatus) {
            return ftStatus;
        }
        int dataSize = 0;
        int TRANSFER_BUFFER_SIZE = 1024;
        byte[] transferBuf = new byte[TRANSFER_BUFFER_SIZE];
        int buf_access_index = 0;
        int queueZeroCount = 0;
        sizeTransferred[0] = 0;
        while (notReadBytes > 0) {
            dataSize = this.mFtDev.getQueueStatus();
            if (dataSize == 0) {
                ++queueZeroCount;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (5 != queueZeroCount || System.currentTimeMillis() - startTime <= (long)iTimeout) continue;
                break;
            }
            queueZeroCount = 0;
            if (dataSize > notReadBytes) {
                dataSize = notReadBytes;
            }
            if (dataSize > TRANSFER_BUFFER_SIZE) {
                dataSize = TRANSFER_BUFFER_SIZE;
            }
            if ((readBytes = this.mFtDev.read(transferBuf, dataSize)) < 0) {
                return 1011;
            }
            for (int i = 0; i < readBytes; ++i) {
                buffer[buf_access_index] = transferBuf[i];
                ++buf_access_index;
            }
            sizeTransferred[0] = sizeTransferred[0] + readBytes;
            notReadBytes -= readBytes;
        }
        return 0;
    }

    @Override
    public int write(byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        int[] maxSize = new int[1];
        int sentBytes = 0;
        if (buffer.length < sizeToTransfer) {
            return 1023;
        }
        if (sizeToTransfer < 1) {
            return 6;
        }
        int ftStatus = this.I2C_Check(false);
        if (ftStatus != 0) {
            return ftStatus;
        }
        ftStatus = this.getMaxTransferSize(maxSize);
        if (0 != ftStatus) {
            return ftStatus;
        }
        byte[] transferBuf = new byte[maxSize[0]];
        int buf_access_index = 0;
        sizeTransferred[0] = 0;
        for (int notSentBytes = sizeToTransfer; notSentBytes > 0; notSentBytes -= sentBytes) {
            int data_size = Math.min(maxSize[0], notSentBytes);
            for (int i = 0; i < data_size; ++i) {
                transferBuf[i] = buffer[buf_access_index];
                ++buf_access_index;
            }
            sentBytes = this.mFtDev.write(transferBuf, data_size);
            if (sentBytes < 0) {
                return 10;
            }
            sizeTransferred[0] = sizeTransferred[0] + sentBytes;
        }
        return 0;
    }

    boolean I2C_ModeCheck() {
        return this.mFt4222Dev.mChipStatus.chip_mode == 0 || this.mFt4222Dev.mChipStatus.chip_mode == 3;
    }

    int I2C_Check(boolean isMaster) {
        if (isMaster ? this.mFt4222Dev.mChipStatus.function != 1 : this.mFt4222Dev.mChipStatus.function != 2) {
            return 1004;
        }
        return 0;
    }

    int getMaxTransferSize(int[] pMaxSize) {
        pMaxSize[0] = 0;
        int maxBuckSize = this.mFt4222Dev.getMaxBuckSize();
        switch (this.mFt4222Dev.mChipStatus.function) {
            case 2: {
                pMaxSize[0] = maxBuckSize;
                break;
            }
            default: {
                return 17;
            }
        }
        return 0;
    }

    public int setClockStretch(boolean bValue) {
        int ftStatus = bValue ? this.cmdSet(94, 1) : this.cmdSet(94, 0);
        return ftStatus;
    }
}

